//
//  BIPaymentCard.h
//  BIViews
//
//  Created by Eric Hochmeister on 12/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCWindowController.h>

@class BIPayment;
@class BIClient;

@interface BIPaymentCard : MCWindowController {
	BIPayment* _originalPayment;
	
	BIPayment* _payment;
	BIClient* _client;
	NSMutableArray* _appliedToInvoices;
		
	BOOL _createPaymentFlag;
    BOOL _editingRetainerPaymentFlag;

	IBOutlet NSTextField* retainerBalanceField;
	IBOutlet NSTextField* retainerBalanceLabel;
	IBOutlet NSPopUpButton* paymentMethodButton;
	
	IBOutlet NSTextField* paymentAmountField;
	IBOutlet NSTextField* baseCurrencyAmountField;
	IBOutlet NSTextField* unappliedAmountField;
	
	IBOutlet NSObjectController* _clientController;
	
	IBOutlet NSArrayController* _appliedToInvoicesController;
	IBOutlet NSArrayController* _paymentMethodTypesController;
	
	IBOutlet NSTableView* regardingTV;
	
	IBOutlet NSButton *alreadyRecordedInAccountingAppSwitch;

}

- (BIPayment *)originalPayment;
- (void)setOriginalPayment:(BIPayment *)anOriginalPayment;
- (BIPayment *)payment;
- (void)setPayment:(BIPayment *)aPayment;
- (BIClient *)client;
- (void)setClient:(BIClient *)aClient;
- (NSMutableArray *)appliedToInvoices;
- (void)setAppliedToInvoices:(NSMutableArray *)anAppliedToInvoices;

- (NSMutableArray*)createDictionaryWithInvoices:(NSArray*)linkToInvoices;

- (void)setupPaymentCardWithPayment:(BIPayment*)aPayment forClient:(BIClient*)aClient linkToInvoices:(NSArray*)theInvoices;


- (IBAction)cancelPayment:(id)sender;
- (IBAction)savePayment:(id)sender;

- (IBAction)changePaymentMethod:(id)sender;

- (void)applyPaymentToInvoices;
- (void)removeApplyPaymentToInvoices;

- (double)maximumAmount;

- (IBAction)help:(id)sender;

- (BOOL)isUsingForeignCurrency;
- (BOOL)isUsingBaseCurrency;


@end
